


/******************************************************************************************
 *                                                                                        *
 * Ex2.      :   Read BCD Code(4bit) From Touch PAD Key 4x4 Out To RS232                  *
 *                  (Format:Press Key SHIFT + key Other)  		                          *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 *                                                                                        *
 * Target MCU     : ATMEL AT89C51RE2                                                      *
 *       	      : X-TAL : 18.432 MHz                                                    *
 *                                                                                        *
 * Keil Editor    : uVision3 V3.62C                                                       *
 * Compiler       : Keil C51 (V9.51)                                                      *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                  *
 * Last Update    : 05/September/2014          						                      *
 *																				          *
 * Port Interface :  -- MCU-AT89C51RE2--	  	  	          -- Key Touch PAD 4x4 --     *
 *                                                                                        *
 *                   P1.0(Input)          Connect                 BCD Colum 1             * 
 *                   P1.1(Input)          Connect                 BCD Colum 2             *
 *                   P1.2(Input)   	      Connect			      BCD Colum 4             *
 *                   P1.3(Input)		  Connect				  BCD Colum 8             *
 *                   P1.4(Input)		  Connect                 T#/R Ststus 1Key        *
 *					 P1.5(Input)	      Connect                 SHIF# Statu 2Key        *
 *																						  *
 *  RS232#1=Uart0 :  P3.0 = RXDO 	      Connect                 Tx Comport PC           *  
 *                   P3.1 = TXD0		  Connect                 Rx Comport PC           * 												  
 *                   Baud Rate = 9600 at Clock 18.432Mhz(6Clock Mode)                     *
 *																						  *
 *    LED DISPLAY : P0.[0..7]	           Connect	              LED Common Anode 		  *
 *                                                                						  *  
 *                                                                             5V		  *
 *                                                                             -+- 		  *
 *                                                              560      \\     |  		  *
 *                                                      P0.0 --/\/\/\---|<|-----+		  *
 *												 	             	 	 .	    |		  *
 *                                                              560      . \\   | 		  *
 *                                                      P0.7 --/\/\/\-----|<|---+  		  *
 *																						  *
 *                                                                                        *
 *   Operation    : When Touch Key will Show Key Code on Heperterminal and LED P0.[0..7]  *                                                  
 *																						  *
 ******************************************************************************************/


#include <at89c51xd2.h>           /* AT89C51xD2 definitions                   */
#include <stdio.h>                /* prototype declarations for I/O functions */

char Check_SHIF(void)   ;
char Check_TR(void)     ;
char RD_KeyCode(void)   ;


//*************************** Main *************************

 main (void) 
  { 
    unsigned int key ;                               

    CKCON0 = 0x01    ;  // div 6 clk mode  X2=1
    AUXR   = 0x10    ;  //Set XRAM = 1792 Byte
 
    //---------initial Uart0 ------------

    BRL     = 0x88  ;  // Baud Rate 9600
    PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   
    BDRCON  = 0x1E  ;  // Select Internal Baud-Rate,enable,0x1E=Fast BR. //0x1C=No fast BR.	 
    SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
    ES      = 0     ;  // Disable Serial Uart  Interrupt    
  
    TI=1            ;
    
 
  printf("*******************************************************************************\r\n");    
  printf("**           Ex2.TEST READ KEY CODE BCD TOUCH PAD4x4 (SHIFT KEY)             **\r\n");        
  printf("*******************************************************************************\r\n"); 
 

   while(1)
   {	 
	 if(!Check_TR())                             //Step1: Check  Touch key (Check_TR()=0:Touch,1:release) 
      {
		key  = RD_KeyCode()                   ;  //Step2: Read Key Code

        if( key == 0x0F)			             //Step3: Check Touch Key Shift(Touch the 1st Key) is Touch 2 Key
		 {
		    do
			 {
		      if(!Check_SHIF())	                  //Step3.1 : Check Touch Key Other(Touch the 2nd Key) by 0:touch,1: not touch
			   {		             
	             key = RD_KeyCode()            ;  //Step 3.2  Read Key Code for Key Shif+Key Other

			     //---------- Step3.3:Program Respond Touch 2key for user ------------

	             P0 = ~key					               ;   //Out Hex data key Code to LED P0[0..7]
			     P0 &= 0x7F                                ;   //Out Status Shif = 0 (ON-LED P0.7)
	             printf("Key_Code BCD = Shift+0x0%X",key)  ;   //Print Key Code Out RS232
	             printf("\n\r")                            ;

		         while(!Check_SHIF()){;} 		   	       ;   //Wait Release 2Key (=1 exit loop) 
		      } 
			 }while(!Check_TR())                           ;   //Loop wait Touch the 2nd Key , Exit loop When release Key Shif or 2Key
		   
		 }
		else	                                //Step4: Check Touch Key Other don't key Shift is Touch 1 Key
		 { 
		   //---------- Step4.1:Program Respond Touch 1 key for user ------------
       
	       P0 = ~key					           ;   //Out Hex data key Code to LED P0[0..7]
	       printf("Key_Code BCD = 0x0%X",key)      ;   //Print Key Code Out RS232
	       printf("\n\r")                          ;

		   while(!Check_TR()){;} 			       ;   //Wait Release Key (=1 exit loop) 	
		
		}  
  
     }	//if Check_TR
   }    //while
 }   //main




 //********************** Sub Program *******************

//---------------------- Check Touch /Release for 2Key -------------------

char Check_SHIF(void)   
{
   char sh   ;
        
	   P1  = 0xFF                ;	 //Set P1 Input
       sh  = P1                  ;   //Read Status Key
	   sh  = sh & 0x20           ;   //Mark bit P1.5 (Statust Press or Release : 2Key)
	
	 if(sh != 0x20)           	     //Check Statue Key
	   return (0)                ;	 //Touch 2Key Return 0 (P1.5=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(P1.5=1)


}

//---------------------- Check Touch /Release 1Key -------------------

char Check_TR(void)    
 {
   char tr   ;
        
	   P1  = 0xFF                ;	 //Set P1 Input
       tr  = P1                  ;   //Read Status Key
	   tr  = tr & 0x10           ;   //Mark bit P1.4 (Statust Press or Release : 1 Key)
	
	 if(tr != 0x10)           	     //Check Statue Key
	   return (0)                ;	 //Touch Key Return 0 (P1.4=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(P1.4=1)
 }



//---------- Read BCD Key Code -----------------

 char RD_KeyCode(void) 
  {
	 unsigned int KeyCode                  ;
   
	      P1      =	0xFF                   ;
     KeyCode      = P1                     ;   //Read Key Code
	 KeyCode      = KeyCode & 0x0F         ;   //Mark bit P1.0-P1.3(Key Code 4 bit)
	 return (KeyCode)                      ;
  }


